#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Gel LogoMod01.fsh    by    nek  
//https://www.shadertoy.com/view/3fS3DG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 screenUV(in vec2 fragCoord) {
  vec2 uv = fragCoord / iResolution.xy * 2.0 - 1.0; // Normalize to [-1, 1]
  uv.x *= iResolution.x / iResolution.y; // Maintain aspect ratio
  return uv;
}
float sdeCircle(vec2 p, float r) {
  return length(p) - r;
}

float sdeEllipse(in vec2 p, in vec2 ab) {
  p = abs(p);
  if(p.x > p.y) {
    p = p.yx;
    ab = ab.yx;
  }
  float l = ab.y * ab.y - ab.x * ab.x;
  float m = ab.x * p.x / l;
  float m2 = m * m;
  float n = ab.y * p.y / l;
  float n2 = n * n;
  float c = (m2 + n2 - 1.0) / 3.0;
  float c3 = c * c * c;
  float q = c3 + m2 * n2 * 2.0;
  float d = c3 + m2 * n2;
  float g = m + m * n2;
  float co;
  if(d < 0.0) {
    float h = acos(q / c3) / 3.0;
    float s = cos(h);
    float t = sin(h) * sqrt(3.0);
    float rx = sqrt(-c * (s + t + 2.0) + m2);
    float ry = sqrt(-c * (s - t + 2.0) + m2);
    co = (ry + sign(l) * rx + abs(g) / (rx * ry) - m) / 2.0;
  } else {
    float h = 2.0 * m * n * sqrt(d);
    float s = sign(q + h) * pow(abs(q + h), 1.0 / 3.0);
    float u = sign(q - h) * pow(abs(q - h), 1.0 / 3.0);
    float rx = -s - u - c * 4.0 + 2.0 * m2;
    float ry = (s - u) * sqrt(3.0);
    float rm = sqrt(rx * rx + ry * ry);
    co = (ry / sqrt(rm - rx) + 2.0 * g / rm - m) / 2.0;
  }
  vec2 r = ab * vec2(co, sqrt(1.0 - co * co));
  return length(r - p) * sign(p.y - r.y);
}

// Smooth max function (used for smooth subtraction)
float smoothMax(float a, float b, float k) {
  float h = max(k - abs(a - b), 0.0) / k;
  return max(a, b) + h * h * k * 0.25;
}

vec3 smoothMax(vec3 a, vec3 b, float k) {
  vec3 h = max(k - abs(a - b), 0.0) / k;
  return max(a, b) + h * h * k * 0.25;
}

// Smooth subtraction
float sdSmoothSubstract(float a, float b, float k) {
  return smoothMax(a, -b, k);
}

vec3 sdSmoothSubstract(vec3 a, vec3 b, float k) {
  return smoothMax(a, -b, k);
}

float sdUnion(float a, float b) {
  return min(a, b);
}

vec3 sdUnion(vec3 a, vec3 b) {
  return min(a, b);
}


float sdeVerticalCapsule( in vec2 p, float r, float h )
{
    p.x = abs(p.x);
    float b = 0.;
    float a = sqrt(1.0-b*b);
    float k = dot(p,vec2(-b,a));
    if( k < 0.0 ) return length(p) - r;
    if( k > a*h ) return length(p-vec2(0.0,h)) - r;
    return dot(p, vec2(a,b) ) - r;
}


vec2 rotateUV(vec2 uv, vec2 pivot, float angle) {
    // Translate UV so pivot is the origin
  uv -= pivot;

    // Rotation matrix
  float s = sin(angle);
  float c = cos(angle);
  mat2 rot = mat2(c, -s, s, c);

    // Rotate the UV and translate back
  uv = rot * uv + pivot;
  return uv;
}
vec3 sdgCircle( in vec2 p, in float r ) 
{
    float d = length(p);
    return vec3( d-r, p/d );
}

vec3 sdgEllipse( vec2 p, in vec2 ab )
{
    vec2 sp = sign(p); p = abs( p );
    
    bool s = dot(p/ab,p/ab)>1.0;
    float w = atan(p.y*ab.x, p.x*ab.y);
    if(!s) w=(ab.x*(p.x-ab.x)<ab.y*(p.y-ab.y))? 1.570796327 : 0.0;
    
    for( int i=0; i<4; i++ )
    {
        vec2 cs = vec2(cos(w),sin(w));
        vec2 u = ab*vec2( cs.x,cs.y);
        vec2 v = ab*vec2(-cs.y,cs.x);
        w = w + dot(p-u,v)/(dot(p-u,u)+dot(v,v));
    }
    vec2  q = ab*vec2(cos(w),sin(w));

    float d = length(p-q);
    return vec3( d, sp*(p-q)/d ) * (s?1.0:-1.0);
}


vec3 sdgCapsule( in vec2 p, in vec2 a, in vec2 b, in float r )
{
    vec2 ba = b-a, pa = p-a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    vec2  q = pa-h*ba;
    float d = length(q);
    return vec3(d-r,q/d);
}

vec3 sdgVerticalCapsule( in vec2 p, in float r, in float h )
{   
    p -= vec2(0.0, h * 0.5);
    return sdgCapsule(p, vec2(0.0, -h * 0.5), vec2(0.0,  h * 0.5), r);
}
// depends on "sdfEuclidean.glsl"
// depends on "sdfOps.glsl"

#ifndef SD_CIRCLE
#define SD_CIRCLE sdgCircle
#endif

#ifndef SD_ELLIPSE
#define SD_ELLIPSE sdgEllipse
#endif

#ifndef SD_VERTICAL_CAPSULE
#define SD_VERTICAL_CAPSULE sdgVerticalCapsule
#endif

#ifndef LOGO_RETURN_TYPE
#define LOGO_RETURN_TYPE vec3
#endif

LOGO_RETURN_TYPE sdG(in vec2 uv) {
  uv -= vec2(0., 0.3);
  float gHeadRadius = 0.5;
  float heatTailSizeRatio = 1.3463;
  float gTailOffset = 1.;
  LOGO_RETURN_TYPE gHead = SD_CIRCLE(uv, gHeadRadius);
  uv *= heatTailSizeRatio;
  uv += vec2(0., gTailOffset);
  LOGO_RETURN_TYPE gTailPos = SD_CIRCLE(uv + vec2(0., -0.05), 0.5);
  LOGO_RETURN_TYPE gTailNeg = SD_ELLIPSE(uv + vec2(0., -0.4-0.02), vec2(0.5, 0.2));
  LOGO_RETURN_TYPE gTail = sdSmoothSubstract(gTailPos, gTailNeg, 0.25);

  return sdUnion(gHead, gTail);
}

LOGO_RETURN_TYPE sdE(in vec2 uv) {
  uv = rotateUV(uv, vec2(0., 0.3), (57.5 + 7.5) * 3.14159 / 180.);
  uv -= vec2(0., 0.3);
  LOGO_RETURN_TYPE gTailPos = SD_CIRCLE(uv, 0.5);

  LOGO_RETURN_TYPE gTailNeg = SD_ELLIPSE(uv + vec2(0., 0.4), vec2(0.2 * 0.7, 0.3 * 0.7));
  LOGO_RETURN_TYPE gTail = sdSmoothSubstract(gTailPos, gTailNeg, 0.25);
  return gTail;
}

LOGO_RETURN_TYPE sdL(in vec2 uv) {
  float radius = 0.3604 / 2.;
  float height = 1.3706 - radius * 2.;
  return SD_VERTICAL_CAPSULE(uv, radius, height);
}

LOGO_RETURN_TYPE sdGel(in vec2 uv) {
  LOGO_RETURN_TYPE sdG = sdG(uv);
  LOGO_RETURN_TYPE sdE = sdE(uv - vec2(1.1 - 0.02, 0.));
  LOGO_RETURN_TYPE sdL = sdL(uv - vec2(1.85 - 0.04, -0.02));
  LOGO_RETURN_TYPE sdf = sdUnion(sdG, sdE);
  return sdUnion(sdf, sdL);
}

float hash21(vec2 p) {
    return fract(sin(dot(p, vec2(12.9898, 78.233))) * 43758.5453);
}

float noise(vec2 p) {
    vec2 i = floor(p); // Integer grid position
    vec2 f = fract(p); // Fractional part

    // Four corner gradients
    float a = hash21(i);
    float b = hash21(i + vec2(1.0, 0.0));
    float c = hash21(i + vec2(0.0, 1.0));
    float d = hash21(i + vec2(1.0, 1.0));

    // Smooth interpolation (fade function)
    vec2 u = f * f * (3.0 - 2.0 * f);

    return mix(mix(a, b, u.x), mix(c, d, u.x), u.y);
}
// depends on "noise.glsl"

#ifndef NOISE_FN
#define NOISE_FN noise
#endif

vec2 opNoiseWarp(in vec2 p, float strength) {
    float n = NOISE_FN(p * 3.0);  // Adjust noise scale
    p.x += (n - 0.5) * strength;
    p.y += (n - 0.5) * strength;
    return p;  // Circle SDF
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    //vec2 uv = fragCoord/iResolution.xy;


 vec2 uv = screenUV(gl_FragCoord.xy);
  uv *= 1.5;
  uv += vec2(1.1 - 0.02 - 0.335, 0.2);

  float sinVal = sin(iTime);
  float sinVal2 = sin(iTime * 0.5);

  uv = opNoiseWarp(uv, 1. - (sinVal2 + 1.0) * 0.5);


  vec3 c = sdGel(uv) + 0.01 + 0.06 * (sinVal + 1.0) * 0.5;
  
  // outer isolines
   // vec3 col = c.x*(0.5 + 0.5*sin(64.0*c.x))*vec3(1.0);
     // inner isolines
    vec3 col = (1.-c.x)*(1.-c.x)*(0.5 + 0.5*sin(64.0*(1.-c.x)))*vec3(1.0);
    // borders	
    //col = mix( vec3(1.0,0.6,0.0), col, smoothstep( 0.04, 0.07, c.x ) );
    // feature points
	//float dd = length( c.yz );
	//col = mix( vec3(1.0,0.6,0.1), col, smoothstep( 0.0, 0.12, dd) );
	//col += vec3(1.0,0.6,0.1)*(1.0-smoothstep( 0.0, 0.04, dd));

	fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

